
#ifndef _1_CRYS_ATP_TST_RC4_Acceptance_h_H
#define _1_CRYS_ATP_TST_RC4_Acceptance_h_H

/*
 * All the includes that are needed for code using this module to
 * compile correctly should be #included here.
 */
#include "CRYS.h"
#include "CRYS_ATP_TST_Defines.h"
#if TST_USE_RC4_DATA/*In case no test vectors are selected - code disabled*/

#ifdef __cplusplus
extern "C"
{
#endif

  /*
   *  Object %name    : %
   *  State           :  %state%
   *  Creation date   :  Mon Mar 07 16:53:29 2005
   *  Last modified   :  %modify_time%
   */
  /** @file
   *  \brief A brief description of this module
   *
   *  \version CRYS_SYS_TS_RC4_Acceptance.h#1:incl:1
   *  \author doronp
   *  \remarks Copyright (C) 2006 by Discretix Technologies Ltd.
   *           All Rights reserved
   */
/******** Defines **********/
/******** Enums ************/
/******** Typedefs  **********/
/******** Structs  **********/
typedef struct SEP_RC4_TestDataStruct{	
	char					    TST_Name[TST_NAME_STRING_LEN];
	DxUint8_t 					TST_Key[TST_RC4_DATA_VEC_SIZE_IN_BYTS];
	DxUint16_t					TST_KeySize;
	DxUint8_t 					TST_input_data[TST_RC4_DATA_VEC_SIZE_IN_BYTS];
	DxUint8_t 					TST_output_data[TST_RC4_DATA_VEC_SIZE_IN_BYTS];
	DxUint8_t 					TST_Expected_output_data[TST_RC4_DATA_VEC_SIZE_IN_BYTS];
	DxUint16_t					TST_dataSize;	
} SEP_RC4_TestDataStruct;
/******** Public Variables ********/
/******** Public Functions ********/
/***************************
* Function Name:                                                           
*  CRYS_ExtApp_ATP_RC4_NON_integrated      
*  
* Inputs:
*  None
*
* Outputs: 
*  CRYSError_t - Function error return                                     
*
* Description:                                                                 
*  This function Is a Acceptance test for RC4 non integrated function,
*  implemented as external SEP application                          .
*  Key size                   - 256
*  Vector sizes used (in bytes) - 512                                 
* Algorithm:       
* 1. Call the SEPQA_RC4_NotIntegrated function to execute test
* 2. Verify function succeded according to the returned error code
*
**************************/                                
CRYSError_t CRYS_ExtApp_ATP_RC4_NON_integrated ( void );

/***************************
* Function Name:                                                           
*  CRYS_ExtApp_ATP_RC4_Integrated      
*  
* Inputs:
*  None
*
* Outputs: 
*  CRYSError_t - Function error return                                     
*
* Description:                                                                 
*  This function Is a Acceptance test for RC4 integrated function,
*  implemented as external SEP application                          .
*  Key size                   - 256
*  Vector sizes used (in bytes) - 512                                 
* Algorithm:       
* 1. Call the SEPQA_RC4_NotIntegrated function to execute test
* 2. Verify function succeded according to the returned error code
*
**************************/                                
CRYSError_t CRYS_ExtApp_ATP_RC4_Integrated ( void );

#ifdef __cplusplus
}
#endif

#endif

#endif

